package com.prime.common.database.domain.operation;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_video_event_record")
public class VideoEventRecordDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 事件图片
     */
    @ApiModelProperty(value = "事件图片")
    @TableField("event_img")
    private String eventImg;

    /**
     * 画框后的事件图片
     */
    @ApiModelProperty(value = "画框后的事件图片")
    @TableField("event_draw_img")
    private String eventDrawImg;

    /**
     * 事件视频
     */
    @ApiModelProperty(value = "事件视频")
    @TableField("event_video")
    private String eventVideo;

    /**
     * 检测到的manhole编号
     */
    @ApiModelProperty(value = "充装管连接的manhole")
    @TableField("manhole_number")
    private String manholeNumber;
    /**
     * 所属虚拟相机ID
     */
    @ApiModelProperty(value = "所属虚拟相机ID")
    @TableField("camera_id")
    private Long cameraId;

    /**
     * 事件类型
     */
    @ApiModelProperty(value = "事件类型")
    @TableField("event_type")
    private Long eventType;

    /**
     * 事件名称
     */
    @ApiModelProperty(value = "事件名称")
    @TableField("event_name")
    private String eventName;

    /**
     * 触发事件的时间
     */
    @ApiModelProperty(value = "触发事件的时间")
    @TableField("event_time")
    private LocalDateTime eventTime;

    /**
     * 用的充装管craneTubeName
     */
    @ApiModelProperty(value = "用的充装管craneTubeName")
    @TableField("crane_tube_name")
    private String craneTubeName;

    /**
     * 充装管连接的manhole
     */
    @ApiModelProperty(value = "充装管连接的manhole")
    @TableField("used_manhole")
    private String usedManhole;

    /**
     * 检测到的manhole数量
     */
    @ApiModelProperty(value = "检测到manhole数量")
    @TableField("manhole_count")
    private Integer manholeCount;

    /**
     * 前牌照Front licence
     */
    @ApiModelProperty(value = "前牌照")
    @TableField("front_licence")
    private String frontLicence;

    /**
     * 后牌照Rear licence
     */
    @ApiModelProperty(value = "后牌照")
    @TableField("rear_licence")
    private String rearLicense;

    /**
     * 罐牌照
     */
    @ApiModelProperty(value = "罐牌照")
    @TableField("tank_licence")
    private String tankLicense;

    /**
     * 罐号
     */
    @ApiModelProperty(value = "罐号")
    private String tankNumber;

    /**
     * 罐顶材料标签
     */
    @ApiModelProperty(value = "罐顶材料标签")
    private String materialLabel;

    /**
     * 是否遗留工具
     */
    @ApiModelProperty(value = "是否遗留工具")
    private String leftoverTools;

    /**
     * 事件状态（是否符合正常流程，0：正常；1：不正常；2：隐藏不显示；3：弃用）
     */
    @ApiModelProperty(value = "事件状态")
    private Integer eventStatus;

    /**
     * 作业编号ID
     */
    @ApiModelProperty(value = "作业编号ID")
    private Long historyAssignmentId;

    /**
     * 作业编号
     */
    @ApiModelProperty(value = "作业编号")
    private String jobNo;

    /**
     * 进入方式
     */
    @ApiModelProperty(value = "进入方式")
    private String entryMethod;

    /**
     * 事件描述
     */
    @ApiModelProperty(value = "事件状态")
    private String eventDesc;
    /**
     * 关联场景
     */
    @ApiModelProperty(value = "关联场景id")
    private Long sceneId;

    /**
     * 关联厂区
     */
    @ApiModelProperty(value = "关联厂区id")
    private Long plantId;

    /**
     * 事件结果
     */
    @ApiModelProperty(value = "事件结果")
    private String eventResult;

    /**
     * 作业类型id
     */
    @ApiModelProperty(value = "作业类型id")
    private Long operationId;

    @ApiModelProperty(value = "算法布控区域id")
    private Long areaId;

    /**
     * 父节点id
     */
    @ApiModelProperty(value = "父节点id")
    private Long parentId;

    /**
     * 详情页面是否显示表格
     */
    @ApiModelProperty(value = "详情页面是否显示表格")
    private Boolean showTable;

    @ApiModelProperty(value = "算法返回的报警区域坐标")
    private String location;

    @ApiModelProperty(value = "额外信息")
    private String extraInfo;

    @ApiModelProperty(value = "额外信息名称")
    private String extraInfoName;


}
