package com.prime.common.database.domain.operation;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_video_alarm_record")
public class VideoAlarmRecordDO extends com.touchbiz.db.starter.domain.BaseDomain {

    @ApiModelProperty(value = "报警图片", required = true)
    private String alarmImage;

    @ApiModelProperty(value = "画框后的报警图片", required = true)
    private String alarmImageDraw;

    @ApiModelProperty(value = "报警视频", required = true)
    private String alarmVideo;

    @ApiModelProperty(value = "报警状态(1：待审批，2：已审批，3：误报)", required = true)
    private Integer alarmState;

    @ApiModelProperty(value = "已处理报警记录的备注信息/已处理结果")
    private String stateComments;

    @ApiModelProperty(value = "报警时间", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone ="GMT+8")
    private LocalDateTime alarmTime;

    @ApiModelProperty(value = "视频报警类型", required = true)
    private Long videoAlarmTypeId;

    @ApiModelProperty(value = "相机Id", required = true)
    private Long cameraId;

    @ApiModelProperty(value = "临时监控场景id", required = true)
    private Long temporaryMonitorId;

    @ApiModelProperty(value = "临时监控场景作业流水编号", required = true)
    private String jobNo;

    @ApiModelProperty(value = "监控类型id", required = true)
    private Long monitorTypeId;

    /**
     * 显示状态
     */
    @ApiModelProperty(value = "显示状态，默认为NULL，为NULL时显示该记录，为0时不显示该记录", required = true)
    @TableField("is_view")
    private Integer isView;

    /**
     * 最后一张图片时间戳
     */
    @ApiModelProperty(value = "最后一张图片时间戳", required = true)
    private Long lastPicTime;

    @ApiModelProperty(value = "关联查询次数（默认为1）", required = true)
    private Integer relateNum;

    @ApiModelProperty(value = "优先级", required = true)
    private String priority;

    @ApiModelProperty(value = "问题解决时间")
    private LocalDateTime problemHandlTime;

    @ApiModelProperty(value = "厂区id", required = true)
    private Long plantId;

    @ApiModelProperty(value = "视频报警厂区id", required = true)
    private String streamVersion;

    @ApiModelProperty(value = "场景id", required = true)
    private Long sceneId;

    @ApiModelProperty(value = "所属作业票ID", required = true)
    private Long workId;

    @ApiModelProperty(value = "反馈人名称", required = true)
    private String alterName;

    @ApiModelProperty(value = "相机名称", required = true)
    private String cameraName;

    @ApiModelProperty(value = "工厂id", required = true)
    private Long factoryId;

    @ApiModelProperty(value = "算法布控区域id")
    private Long areaId;

    @ApiModelProperty(value = "历史作业id", required = true)
    private Long historyAssignmentId;

    @ApiModelProperty(value = "车牌号")
    private String plateNo;

    @ApiModelProperty(value = "检测内容")
    private String alarmResult;

    /**
     * 上传报警记录  ,0未上传 ，1已上传
     */
    @ApiModelProperty(value = "上传状态")
    private Integer uploadState;

    /**
     * 上传时间
     */
    @ApiModelProperty(value = "上传时间")
    private LocalDateTime uploadTime;

    @ApiModelProperty(value = "安全指数分值",required = true)
    @Column(name="safe_num")
    private Integer safeNum;

    @ApiModelProperty(value = "审批人ID")
    private Long approverId;

    @ApiModelProperty(value = "审批时间")
    private LocalDateTime approveTime;

    @ApiModelProperty(value = "是否审批（1：是，0：否）")
    private Boolean approve;

    @ApiModelProperty(value = "额外信息")
    private String extraInfo;

    @ApiModelProperty(value = "额外信息名称")
    private String extraInfoName;

}
