package com.prime.common.database.domain.operation;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@EqualsAndHashCode(callSuper = false)
@Data
@TableName("t_parallel_process")
public class ParallelProcessDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 并行节点名称
     */
    @Size(max = 255)
    @ApiModelProperty(value = "并行节点名称")
    private String name;

    /**
     * 检测区域ID
     */
    @NotNull
    @ApiModelProperty(value = "检测区域ID")
    private Long areaId;

    /**
     * 报警类型；发生时报警（枚举值对应：132001）；未发生时报警（枚举值对应：132002）
     */
    @NotNull
    @ApiModelProperty(value = "报警类型；发生时报警（枚举值对应：132001）；未发生时报警（枚举值对应：132002）")
    private Integer alarmType;

    /**
     * 所属流程模板ID
     */
    @ApiModelProperty(value = "所属流程模板ID")
    private Long flowchartId;


    /**
     * 开始节点ID
     */
    @NotNull
    @ApiModelProperty(value = "开始节点ID")
    private Long startNode;

    /**
     * 结束节点ID
     */
    @NotNull
    @ApiModelProperty(value = "结束节点ID")
    private Long endNode;


}
