package com.prime.common.database.domain.operation;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_history_assignmen")
public class HistoryAssignmentDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 作业编号
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "作业编号", required = true)
    private String jobNumber;

    /**
     * 操作员
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "操作员", required = true)
    private String operator;

    /**
     * 班组长
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "班组长", required = true)
    private String foreman;

    /**
     * 作业对象
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "作业对象", required = true)
    private String workObject;

    /**
     * 状态(1：有违规，0：无违规)
     */
    @NotNull
    @ApiModelProperty(value = "状态(1：有违规,0：无违规)", required = true)
    private Integer state;

    @NotNull
    @ApiModelProperty(value = "视频报警场景id", required = true)
    private Long sceneId;


    /**
     * 创建时间
     */
    @NotNull
    @ApiModelProperty(value = "开始时间", required = true)
    private LocalDateTime startTime;

    /**
     * 修改时间
     */
    @NotNull
    @ApiModelProperty(value = "结束时间", required = true)
    private LocalDateTime endTime;

    /**
     * 报警视频
     */
    @NotNull
    @Size(max = 1024)
    @ApiModelProperty(value = "报警视频", required = true)
    private String alarmVideo;

    /**
     * 错误原因
     */
    @NotNull
    @Size(max = 1024)
    @ApiModelProperty(value = "错误原因", required = true)
    private String errorReason;

    @ApiModelProperty(value = "监控类型id", required = true)
    private Long monitorTypeId;

    @ApiModelProperty(value = "作业类型id", required = true)
    private Long fixedOperationId;

    @ApiModelProperty(value = "车辆停留时长")
    private Integer stayTime;

    @ApiModelProperty(value = "充装作业时长")
    private Integer fillingTime;

}
