package com.prime.common.database.domain.operation;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 作业类型
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_fixed_operation")
public class FixedOperationDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 作业名称
     */
    @NotNull
    @Size(max = 50)
    @ApiModelProperty(value = "作业名称", required = true)
    private String name;

    /**
     * 作业图片
     */
    @ApiModelProperty(value = "作业图片")
    @TableField("operationr_img")
    private String operationImg;

}
