package com.prime.common.database.domain.operation;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.Size;
import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_fixed_flowchart")
public class FixedFlowChartDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 流程模板ID
     */
    @ApiModelProperty(value = "流程模板ID")
    private Long flowchartTemplateId;

    /**
     * 流程节点ID
     */
    @ApiModelProperty(value = "流程节点ID")
    private Long flowchartNodeId;

    /**
     * 上级流程节点ID
     */
    @ApiModelProperty(value = "流程节点ID")
    private String parentFlowchartNodeId;

    /**
     * 场景ID
     */
    @ApiModelProperty(value = "场景ID")
    private Long sceneId;

    /**
     * 作业流水编号
     */
    @Size(max = 255)
    @ApiModelProperty(value = "作业流水编号")
    private String fixJobNo;

    /**
     * 状态(0:未开始；1：进行中；2：正常结束；3：异常)
     */
    @Size(max = 255)
    @ApiModelProperty(value = "状态")
    private String flowchartStatus;

    /**
     * 改变日志记录
     */
    @Size(max = 1025)
    @ApiModelProperty(value = "改变日志记录")
    private String changeLog;

    /**
     * 开始时间
     */
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(value = "结束时间")
    private LocalDateTime endTime;


    @ApiModelProperty("算法Id")
    @TableField("algorithm_id")
    private Long algorithmId;

    @ApiModelProperty("节点名称")
    @TableField("node_name")
    private String nodeName;


}
