package com.prime.common.database.domain.common;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("sys_quartz_job")
public class QuartzJobDO extends com.touchbiz.db.starter.domain.BaseDomain {

    @ApiModelProperty(value = "任务类名")
    private String jobClassName;

    @ApiModelProperty(value = "cron表达式")
    private String cronExpression;

    @ApiModelProperty(value = "参数")
    private String parameter;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "任务名字")
    private String jobName;

    @ApiModelProperty(value = "任务组")
    private String jobGroup;

    @ApiModelProperty(value = "发送邮件帐号")
    private String accountIds;

    @ApiModelProperty(value = "发送周期类型 3：每天，2：每周，1：每月")
    private Integer sendingCycle;

    @ApiModelProperty(value = "发送周期日期，每天则不需要日期，每周则1-7，每月则1-31")
    private Integer sendingDay;

    @ApiModelProperty(value = "发送时间点")
    private String sendingTime;

    @ApiModelProperty(value = "表报时间范围，分1：前一个月，2：前一个周，3：前一天，6：当天，5：本周，4：本月，7：自定义")
    private Integer timeRange;

    @ApiModelProperty(value = "到前几天")
    private Integer startTime;

    @ApiModelProperty(value = "前几天")
    private Integer endTime;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

}
