package com.prime.common.database.domain.basic;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.time.LocalTime;

/**
 * 场景下的日期规划表
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_scene_time_plan")
public class SceneTimePlanDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 算法名称
     */
    @NotNull
    @ApiModelProperty(value = "场景id", required = true)
    private Long sceneId;

    @NotNull
    @ApiModelProperty(value = "相机id,如果相机id不设置则为0", required = true)
    @Min(value = 0)
    private Long cameraId;

    @NotNull
    @ApiModelProperty(value = "算法id,如果算法id不设置则为0", required = true)
    @Min(value = 0)
    private Long algorithmId;

    @NotNull
    @ApiModelProperty(value = "监测区域id,如果监测区域不设置则为0", required = true)
    @Min(value = 0)
    private Long areaId;

    @NotNull
    @ApiModelProperty(value = "用来标记属于哪一种类型1是场景2为场景下相机3为相机下算法,4为区域下的时间")
    private Integer type;

    @NotNull
    @ApiModelProperty(value = "时间类型1是日期类型 2是时间类型")
    private Integer timeType;

    @ApiModelProperty(value = "第几天/那几天")
    private Integer date;

    @NotNull
    @ApiModelProperty(value = "日期类型 跟着WorkDayTypeEnum")
    private Integer dayType;
    
    @ApiModelProperty(value = "开始时间")
    private LocalTime startTime;

    @ApiModelProperty(value = "开始时间")
    private LocalTime endTime;
}
