package com.prime.common.database.domain.basic;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.Size;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_camera_polling_schedule")
public class CameraPollingScheduleDo extends com.touchbiz.db.starter.domain.BaseDomain {

    @ApiModelProperty(value = "轮询分组Id")
    @TableField("polling_group_id")
    private Long pollingGroupId;
    /**
     * 分组个数
     */
    @Size(max = 4)
    @ApiModelProperty(value = "轮询开始时间")
    @TableField("start_time")
    private Integer startTime;

    /**
     * 轮询时间（分钟）
     */
    @Size(max = 4)
    @ApiModelProperty(value = "轮询结束时间")
    @TableField("end_time")
    private Integer endTime;


    /**
     * 轮询时间
     */
    @ApiModelProperty(value = "轮询时间")
    @TableField("polling_time")
    private String pollingTime;


}
