package com.prime.common.database.domain.basic;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/***
 * 告警区域表
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_camera_algorithm_area")
public class CameraAlgorithmAreaDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 相机Id
     */
    @NotNull
    @ApiModelProperty(value = "场景id")
    private Long sceneId;

    /**
     * 相机Id
     */
    @NotNull
    @ApiModelProperty(value = "相机Id")
    private Long cameraId;

    /**
     * 算法id
     */
    @NotNull
    @ApiModelProperty(value = "算法id", required = true)
    private Long algorithmId;

    @NotNull
    @ApiModelProperty(value = "区域名称", required = true)
    private String name;

    /**
     * 图片保存地址
     */
    @ApiModelProperty(value = "图片保存地址")
    private String imgUrl;

    /**
     * 生效区域
     */
    @Size(max = 555)
    @ApiModelProperty(value = "生效区域", required = true)
    private String effectiveArea;

    @ApiModelProperty(value = "工作日期类型 @see WorkDayTypeEnum", reference = "WorkDayTypeEnum")
    private Integer dateType;

    @ApiModelProperty(value = "扩展数据，采用json格式")
    private String extend;

    @ApiModelProperty("透明图片地址")
    private String transparentImgUrl;

    @ApiModelProperty("坐标颜色")
    private String colour;
}
