package com.prime.common.database.domain.basic;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;

/**
 * A Algorithm.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_algorithm")
public class AlgorithmDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 算法名称
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "算法名称", required = true)
    private String algorithmName;

    /**
     * 算法位置
     */
    @ApiModelProperty(value = "算法位置", required = true)
    private String algorithmPlace;


    @ApiModelProperty(value = "状态，0为不可用，1为可用")
    private Integer algorithmStatus = 1;

    @ApiModelProperty(value = "算法类型，0为通用算法，1为流程作业算法，2为事件类型")
    private Integer algorithmType = 0;
    /**
     * 算法描述和风险预估
     */
    @ApiModelProperty(value = "算法描述和风险预估")
    private String algorithmDesc;

    @ApiModelProperty(value = "模型访问地址")
    private String algoUrl;

    @ApiModelProperty(value = "取帧频率")
    private BigDecimal algorithmInterval;

    @ApiModelProperty("检测频率,间隔多少秒")
    private Integer frequency;

    @ApiModelProperty("帧数，取多少张")
    private Integer frameNumber;

    @ApiModelProperty(value = "扩展字段，用来存储一些扩展配置")
    private String extend;

    @ApiModelProperty(value = "额外信息名称")
    private String extraInfoName;
}
