package com.prime.common.database.domain.basic;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * ai entity
 *
 * @author tangd
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_ai")
public class AiDO extends com.touchbiz.db.starter.domain.BaseDomain {


    /**
     * ai服务器名称
     */
    @ApiModelProperty(value = "ai服务器名称")
    @TableField("ai_name")
    private String name;

    /**
     * IP地址
     */
    @ApiModelProperty(value = "ai服务器IP地址")
    private String ip;

    /**
     * ai 服务器描述
     */
    @ApiModelProperty(value = "ai服务器描述")
    @TableField
    private String aiDesc;

    /**
     * 服务器类型
     */
    @ApiModelProperty(value = "服务器类型 1 client 2 video")
    private Integer aiType;

    /**
     * 服务器mac地址
     */
    @ApiModelProperty(value = "设备mac地址")
    private String mac;

    /**
     * 相机最大限制数量
     */
    @ApiModelProperty(value = "相机最大限制数量")
    private Integer cameraMaxNum;

    /**
     * 场景类型
     */
    @ApiModelProperty(value = "场景类型")
    private Integer sceneType;

}
