package com.prime.common.enumration;

import java.util.Optional;

public enum VisitSourceEnum implements IEnum {

    PC(123001, "PC客户端"),

    APP(123002, "APP手机端");

    VisitSourceEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }
    public static Optional<VisitSourceEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(VisitSourceEnum.class, code);
    }
}
