package com.prime.common.enumration;

import java.util.Optional;

public enum SceneTypeEnum implements IEnum {

    MONITOY_TYPE(135001, "临时作业"),

    FIXED_TYPE(135000, "固定作业"),

    PLANT_TYPE(135002, "非作业"),

    GENERAL_TYPE(135004, "通用作业"),

    TEMPLATE_TYPE(135010, "离线视频");

    SceneTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }
    public static Optional<SceneTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(SceneTypeEnum.class, code);
    }
}
