package com.prime.common.enumration;

import lombok.Getter;

import java.util.Optional;

/**
 * @author zhangxuezhen
 * @description: 用户类型
 * @date 2021/1/145:56 下午
 */
@Getter
public enum OperateTypeEnum implements IEnum {

    USER_OPERATE(1, "用户操作"),

    BACKEND_OPERATE(2, "后台操作"),

    SYSTEM_OPERATE(3, "系统操作"),
    ;

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    OperateTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Optional<OperateTypeEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(OperateTypeEnum.class, code);
    }
}
