package com.prime.common.enumration;

import java.util.Optional;

/**
 * @description: 操作模块
 */

public enum OperateModuleEnum implements IEnum {

    CAMERA(114001, "摄像头"),
    ACCOUNT(114002, "用户"),
    SCENE(114003, "场景"),
    ALGORITHM(114004, "算法"),
    SCOPE(114005, "作业空间"),
    DEVICE(114006, "设备"),
    ROLE(114007, "角色"),
    AI(114008, "AI服务器"),
    VIDEO_EVENT_RECORD(114009, "事件记录"),
    VIDEO_ALARM_RECORD(114010, "报警记录"),
    RESOURCE(114011, "菜单资源管理"),
    PATH(114012, "访问路径管理"),
    DICTIONARY(114013, "字典数据维护"),
    TASK(114014, "同步任务"),
    ALARM_POLICY(114015, "告警推送"),
    ;


    OperateModuleEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<OperateModuleEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(OperateModuleEnum.class, code);
    }
}
