package com.prime.common.enumration;

import java.util.Optional;


public enum OperateActionEnum implements IEnum {

    CREATE(115001, "创建"),
    UPDATE(115002, "更新"),
    ENABLE(115003, "启用"),
    DISABLE(115004, "禁用"),
    DELETE(115005, "删除"),
    ISONLINE(115013, "是否在线"),
    STATE(115014, "状态"),

    UPDATE_PRICE(115006, "更新价格"),

    UPDATE_INVENTORY(115007, "更新库存"),
    UPDATE_ROLE_RIGHT(115008, "设置角色权限"),
    REFUND(115009, "退款"),
    SYNC_DEVICE(115010, "同步设备"),
    SYNC_ORDER(115011, "同步订单"),
    SYNC_PRODUCT(115012, "同步产品"),
    ;

    OperateActionEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<OperateActionEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(OperateActionEnum.class, code);
    }
}
