package com.prime.common.enumration;

import lombok.Getter;


public enum ExportTypeEnum implements IEnum {
    QUESTION(1,"videoAlarmRecordExport", "报警记录"),
    EVENT(2,"videoEventRecordExport", "事件记录"),
    USER(3,"user", "用户兑换明细"),
    ORDER(4,"order", "订单"),
    PRODUCT(5,"product", "产品"),
    SPECS(6,"specs", "产品规格"),
    INVENTORY(7,"inventory", "库存"),
    MERCHANT(8,"merchant", "门店");

    ExportTypeEnum(Integer code, String key,String name){
        this.code = code;
        this.name = name;
        this.key = key;
    }

    @Getter
    private final String key;
    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static ExportTypeEnum getByCode(String code) {
        for (ExportTypeEnum value : ExportTypeEnum.values()) {
            if (value.code.equals(code)) {
                return value;
            }
        }
        return null;
    }

}
