package com.prime.common.enumration;

import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.Optional;

public enum AlarmPriorityEnum implements IEnum {

    MINOR(120001, "提示"),
    SIGNIFICANT(120002, "一般"),
    SERIOUS(120003, "严重"),
    CATASTROPHIC(120004, "紧急");

    AlarmPriorityEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<AlarmPriorityEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(AlarmPriorityEnum.class, code);

    }


    public static Optional<AlarmPriorityEnum> getByCodeOrName(String code) {
        if (StringUtils.isEmpty(code)) {
            return Optional.empty();
        }
        var optional = Arrays.stream(AlarmPriorityEnum.values())
                .filter(x -> x.name().equals(code.toUpperCase())).findAny();
        if (!optional.isPresent()) {
            optional = getByCode(Integer.parseInt(code));
        }
        return optional;
    }
}
