package com.prime.common.enumration;


import java.util.Optional;


public enum AlarmPolicyEnum implements IEnum {

    PUSH_METHOD(116, "推送类型"),
    APP(116002, "app"),
    MAIL(116001, "邮件"),
    MESSAGE(116003, "短信"),
    AUDIO(116004, "音频"),
    SYNC_COALMINE_DATA(116005, "上报煤矿信息"),
    WECHAT(116006, "企业微信"),
    WORK_WECHAT_ALARM(116007, "定制版企业微信");

    AlarmPolicyEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }

    public static Optional<AlarmPolicyEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(AlarmPolicyEnum.class, code);
    }


}
