package com.prime.common.enumration;


import java.util.Optional;

public enum AiTypeEnum implements IEnum {

    AI_TYPE(121, "服务类型"),
    VIDEO(121002, "视频推流"),
    CLIENT(121001, "算法截帧");;

    AiTypeEnum(Integer code, String name){
        this.code = code;
        this.name = name;
    }

    private final Integer code;

    public Integer getCode(){
        return code;
    }

    private final String name;

    public String getName(){
        return name;
    }
    public static Optional<OperateActionEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(OperateActionEnum.class, code);
    }


}
