package com.prime.common.enumration;

import java.util.Optional;

public enum AgreementTypeEnum implements IEnum {

    HAI_KANG(1, "海康IPC"),

    HAI_KANG_NVR(2, "海康NVR"),

    GB28181(3, "国标IPC"),

    DA_HUA(4, "大华"),

    VIRTUAL(5, "虚拟相机"),

    RTSP(6, "RTSP"),

    YS(7, "萤石IPC"),

    HUA_WEI_3800(8, "华为IVS3800"),

    HAI_KANG_DVR(9, "海康DVR"),

    DA_HUA_NVR(10, "大华NVR"),

    HAI_KANGS(11, "海康"),

    ONVIF(12, "ONVIF"),

    HAI_KANG_ISC(13, "海康ISC");

    private final Integer code;

    private final String name;

    AgreementTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static Optional<AgreementTypeEnum> getByName(String message) {
        for (AgreementTypeEnum type : AgreementTypeEnum.values()) {
            if (type.getName().equals(message)) {
                return Optional.of(type);
            }
        }
        return Optional.empty();
    }

    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }
}
