package com.prime.common.database.domain.statistics;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.touchbiz.db.starter.domain.BaseDomain;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import com.baomidou.mybatisplus.annotation.TableName;

import java.time.LocalDateTime;

/**
 * 作业效率分析
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@TableName("t_work_efficiency")
public class WorkEfficiencyDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 日期
     */
    @ApiModelProperty(value = "日期")
    @TableField("work_date")
    @JsonFormat(pattern = "yyyy-MM-dd",timezone ="GMT+8")
    private LocalDateTime workDate;

    /**
     * 车辆停留时长
     */
    @ApiModelProperty(value = "KPI统计数量叠加区分字段")
    @TableField("average_stay_time")
    private Integer averageStayTime;

    /**
     * 充装作业时长
     */
    @ApiModelProperty(value = "算法id")
    @TableField("average_filling_time")
    private Integer averageFillingTime;


}
