package com.prime.common.database.domain.rbac;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;

/**
 * 用户相关的场景权限配置
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("sys_target_scene")
public class AccountSceneDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 账号id
     */
    private Long targetId;

    /**
     * 场景id
     */
    private Long sceneId;

    /**
     * 目标类型
     */
    @NotNull
    @ApiModelProperty(value = "推送目标类型")
    private Integer targetType;

    @ApiModelProperty(value = "是否可以审批场景")
    private Boolean approveStatus;
}
