package com.prime.common.database.domain.platform;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_algorithm_model")
public class AlgorithmModelDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 算法模型名称
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "算法模型名称", required = true)
    private String algorithmModelName;

    /**
     * 算法模型类型
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "算法模型类型Id", required = true)
    private Long algorithmModelTypeId;

    /**
     * 模型介绍
     */
    @ApiModelProperty(value = "模型介绍")
    private String modelDetails;

    /**
     * 训练要求
     */
    @ApiModelProperty(value = "训练要求")
    private String requirement;

    /**
     * 图片格式
     */
    @ApiModelProperty(value = "图片格式")
    private String picFormat;

    /**
     * 最低目标像素
     */
    @ApiModelProperty(value = "最低目标像素")
    private String minTargetPixel;

    /**
     * 最低像素
     */
    @ApiModelProperty(value = "最低像素")
    private String minPixel;

    /**
     * 最低上传图片数量
     */
    @ApiModelProperty(value = "最低上传图片数量")
    private Integer minPicNum;

}
