package com.prime.common.database.domain.platform;


import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;

/**
 * 算法实例表
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_algorithm_instance")
public class AlgorithmInstanceDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 实例名称
     */
    @NotNull
    @ApiModelProperty(value = "实例名称", required = true)
    private String instanceName;

    /**
     * 实例描述
     */
    @ApiModelProperty(value = "实例描述")
    private String instanceDescribe;

    /**
     * 模型Id
     */
    @ApiModelProperty(value = "模型Id")
    private Long modelId;

    /**
     * 任务的唯一标识
     */
    @ApiModelProperty(value = "算法任务唯一标识")
    private String taskId;
    /**
     * 当前所处节点
     */
    @ApiModelProperty(value = "当前所处节点")
    private Integer nodes = 1;

    /**
     * 状态
     * 任务状态码
     * 0： 任务未开始执行
     * 1： 任务执行中
     * 2： 任务已完成
     * -1：任务出现异常
     * -2：任务已被停止
     */
    @ApiModelProperty(value = "状态")
    private Integer instanceStatus;

    /**
     * 进度
     */
    @ApiModelProperty(value = "进度")
    private String progress;

    /**
     * 模型路径  算法需要
     */
    @ApiModelProperty(value = "模型路径  算法需要")
    private String modelPath = "";

    /**
     * 算法实例启用状态
     */

    @ApiModelProperty(value = "启用状态")
    private Integer onStart = 0;// 1启动 0关闭


}

