package com.prime.common.database.domain.operation;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_flowchart_template")
public class FlowChartTemplateDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 流程模板名称
     */
    @Size(max = 255)
    @ApiModelProperty(value = "流程模板名称")
    private String flowchartName;

    /**
     * 作业类型（t_fixed_operation主键ID）
     */
    @NotNull
    @ApiModelProperty(value = "作业类型（t_fixed_operation主键ID）", required = true)
    private Long operationType;

    /**
     * 作业最长时间
     */
    @NotNull
    @ApiModelProperty(value = "作业最长时间", required = true)
    private Integer maxOperationTime;

    /**
     * 作业最短时间
     */
    @NotNull
    @ApiModelProperty(value = "作业最短时间", required = true)
    private Integer minOperationTime;

    /**
     * 场景ID
     */
    @NotNull
    @ApiModelProperty(value = "场景ID", required = true)
    private Long sceneId;

}
