package com.prime.common.database.domain.operation;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@EqualsAndHashCode(callSuper = false)
@Data
@TableName("t_flowchart_node")
public class FlowChartNodeDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 流程模板节点名称
     */
    @Size(max = 255)
    @ApiModelProperty(value = "流程模板节点名称")
    private String nodeName;

    /**
     * 节点显示的图标
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "节点显示的图标")
    private String ico;

    /**
     * 节点横坐标
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "节点横坐标")
    private String leftPx;

    /**
     * 节点纵坐标
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "节点纵坐标")
    private String topPx;

    /**
     * 检测区域ID
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "检测区域ID")
    private Long areaId;

    /**
     * 报警类型；发生时报警（枚举值对应：132001）；未发生时报警（枚举值对应：132002）
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "报警类型；发生时报警（枚举值对应：132001）；未发生时报警（枚举值对应：132002）")
    private Integer alarmType;

    /**
     * 流程模板节点描述
     */
    @Size(max = 255)
    @ApiModelProperty(value = "流程模板节点描述")
    private String nodeDesc;

    /**
     * 所属流程模板ID
     */
    @ApiModelProperty(value = "所属流程模板ID")
    private Long flowchartId;


    /**
     * 所属场景id
     */
    @NotNull
    @ApiModelProperty(value = "所属场景id")
    private Long sceneId;

    /**
     * 节点类型（1：大节点；2：小节点）
     */
    @Size(max = 255)
    @ApiModelProperty(value = "节点类型（1：大节点；2：小节点）")
    private Integer nodeCatagory;

    /**
     * 节点状态（0：未开始；1：进行中，2：已完成；3：执行异常）
     */
    @Size(max = 255)
    @ApiModelProperty(value = "节点状态（0：未开始；1：进行中，2：已完成；3：执行异常）")
    private Integer nodeStatus;

    /**
     * 上级节点ID，用逗号分隔
     */
    @Size(max = 255)
    @ApiModelProperty(value = "上级节点ID，用逗号分隔")
    private String parentNodeIds;


    /**
     * DCSID信息
     */
    @ApiModelProperty(value = "dcsId信息")
    private String dcsId;


}
