package com.prime.common.database.domain.operation;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.Size;

//节点完成条件结果记录表
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_fix_node_value")
public class FixtNodeValueDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 相机Id
     */
    @ApiModelProperty(value = "相机Id")
    @TableField("camera_id")
    private Long cameraId;

    /**
     * 流程节点Id
     */
    @ApiModelProperty(value = "流程节点Id")
    @TableField("node_id")
    private Long nodetId;

    /**
     * 节点类型（1.开始节点；2.算法节点；3.DCS节点；4.结束节点）
     */
    @ApiModelProperty(value = "节点类型")
    @TableField("node_type")
    private String nodeType;

    /**
     * 所属流程模板ID
     */
    @TableField("flowchart_id")
    @ApiModelProperty(value = "所属流程模板ID")
    private Long flowchartId;

    /**
     * 所属场景ID
     */
    @TableField("scene_id")
    @ApiModelProperty(value = "所属场景ID")
    private Long sceneId;

    /**
     * 节点类型（1：大节点；2：小节点）
     */
    @Size(max = 255)
    @TableField("node_catagory")
    @ApiModelProperty(value = "节点类型（1：大节点；2：小节点）")
    private String nodeCatagory;

    /**
     * 流水编号
     */
    @ApiModelProperty(value = "流水编号")
    @TableField("job_no")
    private String jobNo;

    /**
     * 节点完成条件参数
     */
    @Size(max = 255)
    @TableField("complete_cond_param")
    @ApiModelProperty(value = "节点完成条件参数")
    private String completeCondParam;

    /**
     * 节点完成条件比较符号
     */
    @Size(max = 255)
    @TableField("complete_cond_operator")
    @ApiModelProperty(value = "节点完成条件")
    private String completeCondOperator;

    /**
     * 节点完成条件值
     */
    @Size(max = 255)
    @TableField("complete_cond_value")
    @ApiModelProperty(value = "节点完成条件值")
    private String completeCondValue;

    /**
     * 节点完成结果
     */
    @TableField("complete_result")
    @ApiModelProperty(value = "节点完成结果")
    private boolean completeResult;

}
