package com.prime.common.database.domain.basic;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * A Algorithm.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("sys_scope")
public class ScopeDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 算法名称
     */
    @NotNull
    @Size(max = 32)
    @ApiModelProperty(value = "空间名称", required = true)
    private String name;

    @NotNull
    @Size(max = 32)
    @ApiModelProperty(value = "空间英文名称", required = true)
    private String nameEn;

    @NotNull
    @ApiModelProperty(value = "状态，0为不可用，1为可用")
    @Min(value = 0)
    private Long parentId;

    @NotNull
    @ApiModelProperty(value = "节点名称，通过这个可以找到上级的节点或者子节点,每三位为一段")
    private String code;

}
