package com.prime.common.database.domain.basic;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalDateTime;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_scene")
public class SceneDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 场景名称
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "场景名称", required = true)
    private String sceneName;

    /**
     * 空间ID
     */
    @NotNull
    @ApiModelProperty(value = "所属空间ID", required = true)
    @TableField("parent_plant_id")
    private Long scopeId;

    /**
     * 固定作业类型id
     */
    @ApiModelProperty(value = "固定作业类型id")
    private Long fixedOperationId;

    /**
     * 作业票Id
     */
    @ApiModelProperty(value = "临时作业类型Id")
    @TableField("work_type_id")
    private Long workTypeId;

    /**
     * 临时作业编号
     */
    @ApiModelProperty(value = "临时作业编号")
    private String workNumber;

    /**
     * 启用状态，1为启用，2为暂停，3为结束
     */
    @ApiModelProperty(value = "启用状态，1为启用，2为暂停，3为结束")
    private Integer workStatus;

    @ApiModelProperty(value = "开始时间")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "结束时间")
    private LocalDateTime endTime;

    /**
     * 流程图id
     */
    @ApiModelProperty(value = "流程图id")
    private Long flowchartId;

    @ApiModelProperty(value = "场景类型")
    private Integer sceneType;

    @ApiModelProperty(value = "页面类型")
    private Integer pageType;

    @ApiModelProperty(value = "工作日期类型 @see WorkDayTypeEnum", reference = "WorkDayTypeEnum")
    private Integer dateType;

    @ApiModelProperty(value = "菜单id",required = true)
    private Long resourceId;

}
