package com.prime.common.database.domain.basic;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.sql.Timestamp;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_camera")
public class CameraDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 相机名称
     */
    @Size(max = 255)
    @ApiModelProperty(value = "相机名称")
    @TableField("camera_name")
    private String cameraName;

    /**
     * 相机类型（1：NVR，2：DVR，3：IPC）
     */
    @ApiModelProperty(value = "相机类型（1：NVR，2：DVR，3：IPC）")
    @TableField("camera_type")
    private String cameraType;

    /**
     * 萤石相机序列号
     */
    @Size(max = 255)
    @ApiModelProperty(value = "萤石相机序列号")
    @TableField("dev_serial")
    private String devSerial;

    /**
     * 萤石相机验证码
     */
    @Size(max = 255)
    @TableField("dev_vcode")
    @ApiModelProperty(value = "萤石相机验证码")
    private String devCode;

    /**
     * 萤石相机 RTMP 流
     */
    @Size(max = 255)
    @ApiModelProperty(value = "萤石相机直播视频流")
    @TableField
    private String rtmpAddress;

    /**
     * ip地址
     */
    @Size(max = 255)
    @ApiModelProperty(value = "ip地址")
    @TableField
    private String ip;

    /**
     * 控制端口
     */
    @Size(max = 255)
    @ApiModelProperty(value = "控制端口")
    @TableField
    private String controlPort;

    /**
     * 视频端口
     */
    @Size(max = 255)
    @ApiModelProperty(value = "视频端口")
    @TableField
    private String videoPort;

    /**
     * 所属厂区id
     */
    @ApiModelProperty(value = "所属厂区id", required = true)
    @TableField
    private Long plantId;

    /**
     * 所属场景id
     */
    @ApiModelProperty(value = "所属场景id", required = true)
    @TableField
    private Long sceneId;

    /**
     * 是否布控（1：未布控，2：已布控）
     */
    @ApiModelProperty(value = "是否布控（1：未布控，2：已布控）")
    @TableField("is_monitor")
    private Integer isMonitor;

    /**
     * 协议:
     */
    @Size(max = 255)
    @ApiModelProperty(value = "协议")
    @TableField
    private String agreement;

    /**
     * 通道名称
     */
    @Size(max = 255)
    @ApiModelProperty(value = "通道名称")
    @TableField
    private String channelName;

    /**
     * 用户名
     */
    @Size(max = 255)
    @ApiModelProperty(value = "用户名")
    @TableField
    private String cameraUsername;

    /**
     * 密码
     */
    @Size(max = 255)
    @ApiModelProperty(value = "密码")
    @TableField
    private String cameraPassword;

    @TableField
    @Size(max = 255)
    @ApiModelProperty(value = "相机位置")
    private String cameraPlace;

    @TableField
    @ApiModelProperty(value = "经度")
    private BigDecimal lng;

    @TableField
    @ApiModelProperty(value = "纬度")
    private BigDecimal lat;

    @TableField
    @ApiModelProperty(value = "物理位置属性（1：固定，2：移动）")
    private Integer locationType;

    @TableField
    @ApiModelProperty(value = "相机位置标签：可以标识用户自定义的属性")
    private String locationLabel;

    @TableField
    @ApiModelProperty(value = "nvr编号")
    private String nvr;

    @TableField
    private String rtspAddress;

    /**
     * 是否在线（1：在线，2：未在线）
     */
    @NotNull
    @ApiModelProperty(value = "是否在线（1：在线，2：未在线）")
    @TableField("is_online")
    private Integer isOnline;

    @Size(max = 255)
    @ApiModelProperty(value = "型号")
    @TableField
    private String cameraVersion;

    @Size(max = 255)
    @ApiModelProperty(value = "品牌")
    @TableField
    private String brandName;

    @ApiModelProperty(value = "采集频率,多少秒采集一张照片")
    @TableField("alter_id")
    private Long captureFrequency;

    @ApiModelProperty(value = "截帧命令")
    @TableField("frame_command")
    private String frameCommand;

    @ApiModelProperty(value = "运行状态, 未检测109001、检测中109002、检测结束109003")
    private Integer checkStatus;

    @ApiModelProperty(value = "最后检测时间")
    @TableField("last_check_time")
    private Timestamp lastCheckTime;

    @ApiModelProperty(value = "流类型")
    @TableField("stream_type")
    private Integer streamType;

    @ApiModelProperty(value = "子码流地址")
    @TableField("sub_code_stream")
    private String subCodeStream;

    @ApiModelProperty(value = "所属平台")
    @TableField("platform_id")
    private Long platformId;

    @ApiModelProperty(value = "平台中相机唯一标识")
    @TableField("platform_unicode")
    private String platformUnicode;

    @ApiModelProperty(value = "视频时长")
    @TableField("video_duration")
    private Integer videoDuration;

}
