package com.prime.common.database.domain.basic;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;

/**
 * A CameraAlgorithm.
 */

/**
 * A CameraAlgorithm.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_camera_algorithm")
public class CameraAlgorithmDO extends com.touchbiz.db.starter.domain.BaseDomain {
    /**
     * 相机Id
     */
    @NotNull
    @ApiModelProperty(value = "相机Id")
    private Long cameraId;

    /**
     * 场景Id
     */
    @ApiModelProperty(value = "场景Id")
    private Long sceneId;

    /**
     * 算法id
     */
    @NotNull
    @ApiModelProperty(value = "算法id", required = true)
    private Long algorithmId;

    /**
     * 优先级
     */
    @NotNull
    @ApiModelProperty(value = "优先级", required = true)
    private Integer priority;

    @ApiModelProperty(value = "是否需要审批")
    private Boolean approve;

    @ApiModelProperty(value = "间隔时间，单位分钟")
    private Integer period;

    @ApiModelProperty(value = "频率，间隔时间内允许报警的次数")
    private Integer frequency;

    @ApiModelProperty(value = "扩展数据，采用json格式")
    private String extend;

    @ApiModelProperty(value = "工作日期类型 @see WorkDayTypeEnum", reference = "WorkDayTypeEnum")
    private Integer dateType;

    @NotNull
    @ApiModelProperty(value = "区分类型，是报警还是事件或者报警与事件见SceneCameraAlgorithmTypeEnum")
    private Integer type;


}
