package com.prime.common.database.domain.basic;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import com.baomidou.mybatisplus.annotation.TableName;
import javax.validation.constraints.NotNull;

@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_algorithm_state")
public class AlgorithmStateDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 算法id
     */
    @ApiModelProperty(value = "算法id", required = true)
    private Long algorithmId;

    /**
     * 判断条件
     */
    @NotNull
    @ApiModelProperty(value = "判断条件", required = true)
    private Integer state;

    /**
     * 检测结果
     */
    @NotNull
    @ApiModelProperty(value = "检测结果", required = true)
    private String detectionResult;

    /**
     * 实例id
     */
    @ApiModelProperty(value = "实例id", required = true)
    private Long instanceId;

}
