package com.prime.common.database.domain.basic;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.math.BigDecimal;

/**
 * A Algorithm.
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_algorithm")
public class AlgorithmDO extends com.touchbiz.db.starter.domain.BaseDomain {

    /**
     * 算法名称
     */
    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "算法名称", required = true)
    private String algorithmName;

    @NotNull
    @Size(max = 255)
    @ApiModelProperty(value = "算法英文名称", required = true)
    private String algorithmNameEn;

    /**
     * 算法位置
     */
    @ApiModelProperty(value = "算法位置", required = true)
    private String algorithmPlace;


    @ApiModelProperty(value = "状态，0为不可用，1为可用")
    private Integer algorithmStatus = 1;

    @ApiModelProperty(value = "算法类型，0为通用算法，1为流程作业算法，2为事件类型")
    private Integer algorithmType = 0;

    @ApiModelProperty(value = "作业类型")
    private Long workType;

    /**
     * 实例id
     */
    @ApiModelProperty(value = "实例id")
    private Long instanceId;

    /**
     * 算法描述和风险预估
     */
    @ApiModelProperty(value = "算法描述和风险预估")
    private String algorithmDesc;

    @ApiModelProperty(value = "路由规则")
    private String routingKey;

    @ApiModelProperty(value = "取帧频率")
    private BigDecimal algorithmInterval;

    @ApiModelProperty(value = "算法模型id")
    private Long algorithmModelId;

    @ApiModelProperty(value = "算法图片")
    private Long algorithmImg;

    @ApiModelProperty(value = "算法图片")
    private String alarmAudio;

    @ApiModelProperty(value = "算法分组数", required = true)
    private Integer alarmGroup;

    @ApiModelProperty("检测频率,间隔多少秒")
    private Integer frequency;

    @ApiModelProperty("帧数，取多少张")
    private Integer frameNumber;

    @ApiModelProperty(value = "配置摄像头视频时间，默认为10秒")
    private Integer alarmVideoDuration;

    @ApiModelProperty(value = "检测算法,该字段为true则保存到事件表，作为事件来看待")
    private Boolean eventRecord;

    @ApiModelProperty(value = "扩展字段，用来存储一些扩展配置")
    private String extend;

    @ApiModelProperty(value = "额外信息名称")
    private String extraInfoName;
}
