package com.prime.common.database.domain.basic;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 告警信息推送规则表
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_alarm_policy")
public class AlarmPolicyDO extends com.touchbiz.db.starter.domain.BaseDomain {


    @NotNull
    @ApiModelProperty(value = "推送目标类型")
    private Integer targetType;

    @NotNull
    @ApiModelProperty(value = "推送目标Id")
    private Long targetId;

    @ApiModelProperty(value = "算法Ids")
    private String algorithmIds;

    @ApiModelProperty(value = "推送时间段")
    @TableField("push_time")
    @Size(max = 64)
    private String pushTimes;

    @ApiModelProperty(value = "场景Id")
    @NotNull
    private Long sceneId;

    /**
     * 推送类型 1:邮件 2:app  3:页面推送 4:其他方式(暂时未定义)
     */
    @ApiModelProperty(value = "推送类型")
    private String pushType;
}
