package com.prime.common.database.domain.basic;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * ai entity
 *
 * @author tangd
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("t_ai")
public class AiDO extends com.touchbiz.db.starter.domain.BaseDomain {


    /**
     * ai服务器名称
     */
    @ApiModelProperty(value = "ai服务器名称")
    @TableField("ai_name")
    private String name;

    /**
     * IP地址
     */
    @ApiModelProperty(value = "ai服务器IP地址")
    private String ip;

    /**
     * ai 服务器描述
     */
    @ApiModelProperty(value = "ai服务器描述")
    @TableField("ai_desc")
    private String desc;

    /**
     * 添加或编辑
     */
    @ApiModelProperty(value = "添加或编辑 0:添加, 1:编辑")
    private Integer state;

    /**
     * 工厂id
     */
    @ApiModelProperty(value = "工厂id")
    private Long factoryId;

    /**
     * 工厂唯一标识
     */
    @ApiModelProperty(value = "工厂唯一标识")
    private String uniqued;

    /**
     * 是否在线
     */
    @ApiModelProperty(value = "是否在线 1 在线 2 未在线")
    @TableField("is_online")
    private Integer isOnline;

    /**
     * 服务器类型
     */
    @ApiModelProperty(value = "服务器类型 1 client 2 video")
    private Integer aiType;


    /**
     * 服务器mac地址
     */
    @ApiModelProperty(value = "设备mac地址")
    private String mac;

    /**
     * 公钥effective
     */
    @ApiModelProperty(value = "公钥")
    private String publicKey;

    /**
     * 私钥
     */
    @ApiModelProperty(value = "私钥")
    private String privateKey;

    /**
     * 相机最大限制数量
     */
    @ApiModelProperty(value = "相机最大限制数量")
    private Integer cameraMaxNum;

    /**
     * 场景类型
     */
    @ApiModelProperty(value = "场景类型")
    private Integer sceneType;

}
