/*
 * Decompiled with CFR 0.152.
 */
package com.prime.common.enumration;

import com.prime.common.enumration.EnumUtils;
import com.prime.common.enumration.IEnum;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.util.StringUtils;

public enum AlarmPriorityEnum implements IEnum
{
    MINOR(120001, "\u63d0\u793a"),
    SIGNIFICANT(120002, "\u4e00\u822c"),
    SERIOUS(120003, "\u4e25\u91cd"),
    CATASTROPHIC(120004, "\u7d27\u6025");

    private final Integer code;
    private final String name;

    private AlarmPriorityEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static Optional<AlarmPriorityEnum> getByCode(Integer code) {
        return EnumUtils.getByCode(AlarmPriorityEnum.class, code);
    }

    public static Optional<AlarmPriorityEnum> getByCodeOrName(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return Optional.empty();
        }
        Optional<AlarmPriorityEnum> optional = Arrays.stream(AlarmPriorityEnum.values()).filter(x -> x.name().equals(code.toUpperCase())).findAny();
        if (!optional.isPresent()) {
            optional = AlarmPriorityEnum.getByCode(Integer.parseInt(code));
        }
        return optional;
    }
}

