package com.prime.client.api.feign;

import com.prime.client.api.constant.ServiceNameConstants;
import com.prime.client.api.dto.request.ScheduledTaskAddRequest;
import com.touchbiz.common.entity.result.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
@FeignClient(value = ServiceNameConstants.OFF_LINE)
public interface ScheduledTaskApi  extends Serializable {
    String TEMPORARY_BASE_URL = "/api/v2/temporary/scheduledTask";

    @PostMapping(TEMPORARY_BASE_URL)
    @ApiOperation(value = "修改定时任务", tags = {"V4.0"}, notes = "修改定时任务")
    Result add(@RequestBody ScheduledTaskAddRequest request);

    @PutMapping(TEMPORARY_BASE_URL)
    @ApiOperation(value = "修改定时任务", tags = {"V4.0"}, notes = "修改定时任务")
    Result update(@RequestBody ScheduledTaskAddRequest request);

    @GetMapping(TEMPORARY_BASE_URL+"/resume/{id}")
    @ApiOperation(value = "开启", tags = {"V4.0"}, notes = "开启定时任务")
    Result resumeJob( @PathVariable Long id);


    @GetMapping(TEMPORARY_BASE_URL+"/pause/{id}")
    @ApiOperation(value = "关闭定时任务", tags = {"V4.0"}, notes = "关闭定时任务")
    Result pauseJob(@PathVariable Long id);

    @DeleteMapping(TEMPORARY_BASE_URL+"/{id}")
    @ApiOperation(value = "删除", tags = {"V4.0"}, notes = "修改定时任务")
    Result delete(@PathVariable Long id);
}
