package com.prime.client.api.feign;

import com.prime.client.api.constant.ServiceNameConstants;
import com.touchbiz.common.entity.result.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.io.Serializable;

@FeignClient(value = ServiceNameConstants.OFF_LINE)
public interface RemoteOfflineApi extends Serializable {

    String BASE_URL = "/api/v2/client/camera";

    @ApiOperation(httpMethod = "GET", value = "离线视频格式转换")
    @GetMapping(BASE_URL+"/{cameraId}/videoConverted")
    Result videoConverted(@PathVariable Long cameraId);

}
