package com.prime.client.api.feign;

import com.prime.client.api.constant.ServiceNameConstants;
import com.touchbiz.common.entity.result.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.Serializable;

@FeignClient(value = ServiceNameConstants.PROVIDER_SERVICE)
public interface RemoteCameraVideoApi extends Serializable {

    String BASE_URL = "/api/v2/video/camera";

    @ApiOperation(httpMethod = "GET", value = "获取相机地址")
    @GetMapping(BASE_URL + "/getVideoUrl")
    Result getVideoUrl(@RequestParam(value = "cameraId") Long cameraId,
                       @RequestParam(value = "rs", required = false, defaultValue = "") String paramRs, @RequestParam(value = "rbv", required = false, defaultValue = "") String paramRbv,
                       @RequestParam(value = "fr", required = false, defaultValue = "") String paramFr);

}
