package com.prime.client.api.feign;

import com.prime.client.api.constant.ServiceNameConstants;
import com.prime.client.api.dto.request.CameraRequest;
import com.prime.client.api.dto.request.PlatformAccountRequest;
import com.prime.client.api.dto.response.CameraStateTimeDto;
import com.prime.client.api.dto.response.GetSimulationDeviceDto;
import com.prime.client.api.dto.response.PlatformCameraResponse;
import com.touchbiz.common.entity.result.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.io.Serializable;
import java.util.List;

@FeignClient(value = ServiceNameConstants.PROVIDER_SERVICE)
public interface RemoteCameraApi extends Serializable {

    String BASE_URL = "/api/v2/client/camera";

    @ApiOperation(httpMethod = "POST", value = "根据协议获取相机通道信息")
    @PostMapping(BASE_URL+"/query")
    Result<List<GetSimulationDeviceDto>> query(@RequestBody CameraRequest request);

    @ApiOperation(httpMethod = "POST", value = "根据协议进行登录操作")
    @PostMapping(BASE_URL+"/login")
    Result<Boolean> login(@RequestBody CameraRequest request);

    @ApiOperation(httpMethod = "GET", value = "查询相机是否在线")
    @GetMapping(BASE_URL+"/{cameraId}/isOnline")
    Result<Boolean> cameraIsOnline(@PathVariable Long cameraId);

    @ApiOperation(httpMethod = "GET", value = "查询相机状态")
    @GetMapping(BASE_URL+"/{cameraId}/state")
    Result<CameraStateTimeDto> cameraState(@PathVariable Long cameraId) ;

    @ApiOperation(httpMethod = "GET", value = "查询该相机上传图片base64")
    @GetMapping(BASE_URL+"/{cameraId}/lastPictureBase")
    Result<String> lastPictureBase(@PathVariable Long cameraId) ;

    @ApiOperation(httpMethod = "POST", value = "平台账号获取相机列表")
    @PostMapping(BASE_URL+"/queryCameraList")
    Result<List<PlatformCameraResponse>> queryCameraList(@RequestBody PlatformAccountRequest request);

}
