package com.prime.client.api.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author maoning
 */
@Data
public class ScheduledTaskAddRequest {

    @ApiModelProperty("定时任务id，如果修改则id为必填")
    private Long id;

    @NotBlank
    @NotNull(message = "任务名称不能为空")
    @ApiModelProperty(value = "任务名称", required = true)
    private String jobName;

    /**任务类名*/
    @NotNull(message = "任务类名不能为空")
    @ApiModelProperty(value = "任务名称", required = true)
    private String jobClassName;

    /**状态 0正常 -1停止*/
    @ApiModelProperty(value = "任务状态", required = true,notes = "0为开启，-1为不开启")
    @NotNull(message = "任务状态不能为空")
    private Integer status;

    @NotNull(message = "任务分组不能为空")
    @ApiModelProperty(value = "任务分组", required = true)
    private String jobGroup;


    @NotNull(message = "cron表达式不能为空")
    @ApiModelProperty(value = "cron表达式", required = true)
    private String cronExpression;










}
