package com.prime.client.api.dto.request;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;


@Data
public class CameraRequest {

    /**
     * 相机类型（1：NVR，2：DVR，3：IPC）
     */
    @ApiModelProperty(value = "相机类型（1：NVR，2：DVR，3：IPC）")
    private String cameraType;

    /**
     * 萤石相机序列号
     */
    @Size(max=255)
    @ApiModelProperty(value = "萤石相机序列号")
    private String devSerial;

    /**
     * 萤石相机验证码
     */
    @Size(max=255)
    @ApiModelProperty(value = "萤石相机验证码")
    private String devCode;

    /**
     * 萤石相机 RTMP 流
     */
    @Size(max = 255)
    @ApiModelProperty(value = "萤石相机直播视频流")
    private String rtmpAddress;

    /**
     * ip地址
     */
    @Size(max = 255)
    @ApiModelProperty(value = "ip地址")
    private String ip;

    /**
     * 控制端口
     */
    @Max(value = 99999)
    @Min(value = 0)
    @ApiModelProperty(value = "控制端口")
    private Integer controlPort;

    /**
     * 视频端口
     */
    @Size(max = 255)
    @ApiModelProperty(value = "视频端口")
    private String videoPort;


    /**
     * 协议:
     */
    @Size(max = 255)
    @ApiModelProperty(value = "协议")
    private String agreement;

    /**
     * 通道名称
     */
    @Size(max = 255)
    @ApiModelProperty(value = "通道名称")
    private String channelName;

    /**
     * 用户名
     */
    @Size(max = 255)
    @ApiModelProperty(value = "用户名")
    private String cameraUsername;

    /**
     * 密码
     */
    @Size(max = 255)
    @ApiModelProperty(value = "密码")
    private String cameraPassword;

    @ApiModelProperty(value = "nvr编号")
    private String nvr;

    private String rtspAddress;

    private Long platformId;


}
