/*
 * Decompiled with CFR 0.152.
 */
package de.kelanisystem.kelanilogger.util;

import de.kelanisystem.kelanilogger.KelaniLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class FileUtil {
    private static final int MAX_NUMBER_OF_LOGS = 5;
    private final KelaniLogger kelaniLogger;

    public FileUtil(KelaniLogger kelaniLogger) {
        this.kelaniLogger = kelaniLogger;
    }

    public void createFileWithFolder(File logFile) throws IOException {
        if (!logFile.getParentFile().exists() && !logFile.getParentFile().mkdirs()) {
            throw new IOException("Couldn't create parent file: " + logFile.getCanonicalPath());
        }
        if (!logFile.exists() && !logFile.createNewFile()) {
            throw new IOException("Couldn't create file: " + logFile.getCanonicalPath());
        }
    }

    public void clearOldLogs(File dir) throws IOException {
        File directory = new File(dir, KelaniLogger.FILE_SEPARATOR);
        if (directory.exists()) {
            CopyOnWriteArrayList<Object> files = new CopyOnWriteArrayList<Object>(Arrays.asList((Object[])Objects.requireNonNull(directory.listFiles())));
            files.sort(Comparator.comparingLong(File::lastModified));
            this.removeOldFilesAndLocks(files);
            this.deleteAllRemainingFiles(files);
        }
    }

    private void removeOldFilesAndLocks(List<File> files) throws IOException {
        for (File file : files) {
            if (file.lastModified() <= System.currentTimeMillis() - TimeUnit.DAYS.toMillis(7L)) {
                if (file.delete() || !files.remove(file)) continue;
                throw new IOException("Couldn't delete directory: " + file.getCanonicalPath());
            }
            if (!file.getName().contains(".lck")) continue;
            files.remove(file);
        }
    }

    private void deleteAllRemainingFiles(List<File> files) throws IOException {
        if (files.size() >= 5) {
            for (int i = 0; i < files.size(); ++i) {
                if (files.size() <= 5) continue;
                if (!files.get(i).delete()) {
                    throw new IOException("Couldn't delete directory: " + files.get(i).getCanonicalPath());
                }
                files.remove(i);
            }
        }
    }
}

