/*
 *
 *  Copyright (c) 2020.
 *  This system ist developed by Jes Müller and Quirin Brändli!
 *  All rights reserved!
 *
 *  Please read the licence for more information.
 *
 */

package de.kelanisystem.kelanilogger.handler;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class KelaniConsoleHandler extends ConsoleHandler {
    private boolean formatSet;
    private boolean levelSet;

    public KelaniConsoleHandler(final Level logLevel) {
        this(logLevel, null);
    }

    public KelaniConsoleHandler(final Formatter formatter) {
        this(null, formatter);
    }

    public KelaniConsoleHandler(final Level logLevel, final Formatter formatter) {
        super();
        if (formatter != null) this.setFormatter(formatter);
        if (logLevel != null) this.setLevel(logLevel);
    }

    public boolean isFormatSet() {
        return formatSet;
    }

    public boolean isLevelSet() {
        return levelSet;
    }

    @Override
    public abstract void publish(LogRecord logRecord);
}
