/*
 * Decompiled with CFR 0.152.
 */
package de.kelanisystem.kelanilogger.formats;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class DefaultFormat
extends Formatter {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toUpperCase(Locale.US).contains("WINDOWS");
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_GREEN = "\u001b[32m";
    private static final String ANSI_YELLOW = "\u001b[33m";
    private static final String ANSI_WHITE = "\u001b[37m";
    private static final String ANSI_CYAN = "\u001b[36m";

    @Override
    public String format(LogRecord logRecord) {
        StringBuilder builder = new StringBuilder();
        Level level = logRecord.getLevel();
        if (!IS_WINDOWS) {
            builder.append(this.getLevelColor(logRecord.getLevel()));
        }
        if (level != Level.OFF) {
            builder.append('[').append(this.calcDate(logRecord.getMillis())).append(']').append(" [").append(logRecord.getLevel().getName()).append(']');
            if (!IS_WINDOWS) {
                builder.append(ANSI_WHITE);
            }
            builder.append(" - ");
        }
        builder.append(logRecord.getMessage());
        Object[] params = logRecord.getParameters();
        if (params != null) {
            builder.append('\t');
            for (int i = 0; i < params.length; ++i) {
                builder.append(params[i]);
                if (i >= params.length - 1) continue;
                builder.append(", ");
            }
        }
        builder.append(this.getAnsiReset()).append('\n');
        return builder.toString();
    }

    private String getAnsiReset() {
        return IS_WINDOWS ? "" : ANSI_RESET;
    }

    private String getLevelColor(Level level) {
        String returnStatement = ANSI_WHITE;
        if (Level.INFO.equals(level)) {
            returnStatement = ANSI_CYAN;
        } else if (Level.SEVERE.equals(level)) {
            returnStatement = ANSI_RED;
        } else if (Level.WARNING.equals(level)) {
            returnStatement = ANSI_YELLOW;
        } else if (Level.FINE.equals(level)) {
            returnStatement = ANSI_GREEN;
        }
        return returnStatement;
    }

    private String calcDate(long milliseconds) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        Date date = new Date(milliseconds);
        return dateFormat.format(date);
    }
}

