/*
 * Decompiled with CFR 0.152.
 */
package de.kelanisystem.kelanilogger.config;

import de.kelanisystem.kelanilogger.handler.KelaniConsoleHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Level;

public class KelaniLoggerConfig {
    private boolean deactiveConsoleHandler = false;
    private String logo;
    private boolean fileLogActive;
    private File directory;
    private String logName;
    private Formatter formatter;
    private Level logLevelConsole;
    private Level logLevelFile;
    private final String loggerName;
    private final List<KelaniConsoleHandler> kelaniConsoleHandlers = new ArrayList<KelaniConsoleHandler>();

    public KelaniLoggerConfig(String loggerName) {
        this.loggerName = loggerName;
        this.logLevelConsole = Level.INFO;
        this.logLevelFile = Level.INFO;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public boolean isFileLogActive() {
        return this.fileLogActive;
    }

    public void setFileLogActive(boolean fileLogActive) {
        this.fileLogActive = fileLogActive;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String getLogFileName() {
        return this.loggerName == null ? this.logName : this.loggerName;
    }

    public void setLogFileName(String logName) {
        this.logName = logName;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Level getLogLevelConsole() {
        return this.logLevelConsole;
    }

    public void setLogLevels(Level logLevel) {
        this.logLevelConsole = logLevel;
        this.logLevelFile = logLevel;
    }

    public void setLogLevelConsole(Level logLevelConsole) {
        this.logLevelConsole = logLevelConsole;
    }

    public Level getLogLevelFile() {
        return this.logLevelFile;
    }

    public void setLogLevelFile(Level logLevelFile) {
        this.logLevelFile = logLevelFile;
    }

    public boolean isDefaultConsoleHandlerDeactivated() {
        return this.deactiveConsoleHandler;
    }

    public void deactivateDefaultConsoleHandler() {
        this.deactiveConsoleHandler = true;
    }

    public List<KelaniConsoleHandler> getKelaniConsoleHandlers() {
        return this.kelaniConsoleHandlers;
    }

    public void setKelaniConsoleHandlers(KelaniConsoleHandler ... consoleHandlers) {
        this.kelaniConsoleHandlers.addAll(Arrays.asList(consoleHandlers));
    }
}

