/*
 * Decompiled with CFR 0.152.
 */
package de.kelanisystem.kelanilogger;

import de.kelanisystem.kelanilogger.config.KelaniLoggerConfig;
import de.kelanisystem.kelanilogger.exceptions.NoFileSpecifiedException;
import de.kelanisystem.kelanilogger.formats.DefaultFormat;
import de.kelanisystem.kelanilogger.handler.KelaniConsoleHandler;
import de.kelanisystem.kelanilogger.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KelaniLogger {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private Logger logger;
    private final FileUtil fileUtil = new FileUtil(this);

    public KelaniLogger(KelaniLoggerConfig kelaniLoggerConfig) {
        this.createLogger(kelaniLoggerConfig);
        this.createFileLogger(kelaniLoggerConfig);
        this.finish(kelaniLoggerConfig);
    }

    private void createLogger(KelaniLoggerConfig kelaniLoggerConfig) {
        this.logger = Logger.getLogger(kelaniLoggerConfig.getLoggerName());
        this.logger.setUseParentHandlers(false);
        if (!kelaniLoggerConfig.getKelaniConsoleHandlers().isEmpty()) {
            for (KelaniConsoleHandler kelaniConsoleHandler : kelaniLoggerConfig.getKelaniConsoleHandlers()) {
                if (!kelaniConsoleHandler.isFormatSet()) {
                    kelaniConsoleHandler.setFormatter(new DefaultFormat());
                }
                if (!kelaniConsoleHandler.isLevelSet()) {
                    kelaniConsoleHandler.setLevel(kelaniLoggerConfig.getLogLevelConsole());
                }
                this.logger.addHandler(kelaniConsoleHandler);
            }
        }
    }

    private void createFileLogger(KelaniLoggerConfig kelaniLoggerConfig) {
        try {
            if (kelaniLoggerConfig.getDirectory() == null || kelaniLoggerConfig.getLogFileName() == null) {
                throw new NoFileSpecifiedException();
            }
            Date date = new Date();
            String logFileName = this.parseLogName(date, kelaniLoggerConfig);
            File logFile = new File(logFileName);
            this.fileUtil.createFileWithFolder(logFile);
            this.setupFileHandler(kelaniLoggerConfig, logFileName);
            this.fileUtil.clearOldLogs(logFile.getParentFile());
        }
        catch (NoFileSpecifiedException | IOException e) {
            this.error(e.getMessage());
        }
    }

    private void setupFileHandler(KelaniLoggerConfig kelaniLoggerConfig, String logFileName) throws IOException {
        FileHandler fileHandler = new FileHandler(logFileName, true);
        fileHandler.setFormatter(kelaniLoggerConfig.getFormatter());
        fileHandler.setLevel(kelaniLoggerConfig.getLogLevelFile());
        this.logger.addHandler(fileHandler);
    }

    private void finish(KelaniLoggerConfig kelaniLoggerConfig) {
        if (kelaniLoggerConfig.getLogo() != null) {
            this.off(kelaniLoggerConfig.getLogo());
        }
    }

    private String parseLogName(Date date, KelaniLoggerConfig config) throws IOException {
        String filename = config.getLogFileName();
        filename = filename.replace("%LOGGER_NAME%", config.getLogFileName()).replace("%LOG_CREATE_TIME", date.toString());
        String name = config.getDirectory().getCanonicalPath().endsWith("log") || config.getDirectory().getCanonicalPath().endsWith("logs") ? config.getDirectory().getCanonicalFile() + FILE_SEPARATOR + filename : config.getDirectory().getCanonicalFile() + FILE_SEPARATOR + "logs" + FILE_SEPARATOR + filename;
        return name;
    }

    public void info(Object object) {
        this.log(Level.INFO, object);
    }

    public void warning(Object object) {
        this.log(Level.WARNING, object);
    }

    public void error(Object object) {
        this.log(Level.SEVERE, object);
    }

    public void config(Object object) {
        this.log(Level.INFO, object);
    }

    public void log(Level level, Object object) {
        if (this.logger.isLoggable(level)) {
            this.logger.log(Level.INFO, object::toString);
        }
    }

    public void fine(Object object) {
        this.log(Level.FINE, object);
    }

    public void off(Object object) {
        this.log(Level.OFF, object);
    }

    public void logMany(Level level, List<Object> objects) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objects.size(); ++i) {
            stringBuilder.append(objects.get(i));
            if (i == objects.size() - 1) continue;
            stringBuilder.append('\n');
        }
        this.log(level, stringBuilder.toString());
    }

    public void addHandlers(ConsoleHandler ... handlers) {
        for (ConsoleHandler handler : handlers) {
            this.logger.addHandler(handler);
        }
    }

    public void removeHandlers(ConsoleHandler ... handlers) {
        for (ConsoleHandler handler : handlers) {
            this.logger.addHandler(handler);
        }
    }
}

