/*
 * Decompiled with CFR 0.152.
 */
package de.kelanisystem.kelaniconfig;

import de.kelanisystem.kelaniconfig.KelaniYamlFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleyaml.exceptions.InvalidConfigurationException;

public class KelaniConfigManager {
    private final String separator = System.getProperty("file.separator");
    private final Map<String, KelaniYamlFile> configs;
    private Path configFolder = Paths.get("data/", new String[0]);

    public KelaniConfigManager() {
        this.configs = new HashMap<String, KelaniYamlFile>();
    }

    public KelaniConfigManager(Path configFolder) {
        this.configFolder = configFolder;
        this.configs = new HashMap<String, KelaniYamlFile>();
    }

    public List<KelaniYamlFile> createFile(String ... names) throws IOException, InvalidConfigurationException {
        return this.createFileWithOwnPath(this.configFolder, names);
    }

    public List<KelaniYamlFile> createFile(String path, String name) throws IOException, InvalidConfigurationException {
        ArrayList configurations = new ArrayList();
        Path newPath = Paths.get(this.configFolder.toString(), path);
        return this.createFileWithOwnPath(newPath, name);
    }

    public List<KelaniYamlFile> createFileWithOwnPath(Path path, String ... names) throws IOException, InvalidConfigurationException {
        ArrayList<KelaniYamlFile> configurations = new ArrayList<KelaniYamlFile>();
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        for (String name : names) {
            KelaniYamlFile yamlFile = new KelaniYamlFile(new File(path + this.separator + name + ".yml"), name);
            this.configs.put(name, yamlFile);
            configurations.add(yamlFile);
        }
        return configurations;
    }

    public KelaniYamlFile getConfig(String configName) {
        return this.configs.get(configName);
    }

    public void copyDefaults(String configName, boolean bool) throws IOException {
        this.configs.get(configName).options().copyDefaults(bool);
        this.save(configName);
    }

    public void addDefault(String configName, String key, Object value) {
        this.configs.get(configName).addDefault(key, value);
    }

    public void addDefaults(String configName, Map<String, Object> defaults) {
        this.configs.get(configName).addDefaults(defaults);
    }

    public Object get(String configName, String key) {
        return this.configs.get(configName).get(key);
    }

    public String getString(String configName, String key) {
        return this.configs.get(configName).getString(key);
    }

    public Boolean getBoolean(String configName, String key) {
        return this.configs.get(configName).getBoolean(key);
    }

    public Integer getInteger(String configName, String key) {
        return this.configs.get(configName).getInt(key);
    }

    public List<String> getStringList(String configName, String key) {
        return this.configs.get(configName).getStringList(key);
    }

    public List<Integer> getIntegerList(String configName, String key) {
        return this.configs.get(configName).getIntegerList(key);
    }

    public List<?> getList(String configName, String key) {
        return this.configs.get(configName).getList(key);
    }

    public void setHeader(String configName, String header) throws IOException {
        this.configs.get(configName).options().header(header);
        this.save(configName);
    }

    public void save(String configName) throws IOException {
        this.configs.get(configName).save();
    }
}

